#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Spinal CaveMod01.fsh   by  lsdlive 
//https://www.shadertoy.com/view/4s3yDM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159
#define TWO_PI 2.*PI

// hglib / iq
// http://mercury.sexy/hg_sdf/
// https://iquilezles.org/articles/distfunctions
float rep(float p, float d) {
	return mod(p - d*.5, d) - d*.5;
}

vec3 rep(vec3 p, float d) {
	return mod(p - d*.5, d) - d*.5;
}

void mo(inout vec2 p, vec2 d) {
	p.x = abs(p.x) - d.x;
	p.y = abs(p.y) - d.y;
	if (p.y > p.x)p = p.yx;
}

void amod(inout vec2 p, float m) {
	float a = rep(atan(p.x, p.y), m);
	p = vec2(cos(a), sin(a)) * length(p);
}

mat2 r2d(float a) {
	float c = cos(a), s = sin(a);
	return mat2(c, s, -s, c);
}

#define sph(p, r) (length(p) - r)
#define cube(p, b) length(max(abs(p) - vec3(b), 0.))

float cyl(vec3 p, float r, float h) {
	return max(length(p.xz) - r, abs(p.y) - h);
}

// signed
float box(vec3 p, vec3 b)
{
	vec3 d = abs(p) - b;
	return min(max(d.x, max(d.y, d.z)), 0.0) + length(max(d, 0.0));
}

// iq via leon/koltes
float smoo(float a, float b, float r) {
	return clamp(.5 + .5*(b - a) / r, 0., 1.);
}

float smin(float a, float b, float r) {
	float h = smoo(a, b, r);
	return mix(b, a, h) - r*h*(1. - h);
}

float smax(float a, float b, float r) {
	float h = smoo(a, b, r);
	return mix(a, b, h) + r*h*(1. - h);
}

// Tunnel pattern studied from shane & shau
// i.e. https://www.shadertoy.com/view/4tKXzV
vec2 path(float t) {
	float a = sin(t*.2 + 1.5), b = sin(t*.2);
	return vec2(a*2., a*b);
}

vec4 opu(vec4 a, vec4 b) {
	return a.w < b.w ? a : b;
}

//return vec4: vec3 color + float distance
vec4 de(vec3 p) {

	vec4 surface;
	vec3 q;

	p.xy -= path(p.z);


	float bg_tun = -length(p.xy) + 4.;

	p.xy *= r2d(-3.14*.5);
	p.xy *= r2d(p.z*.1);
	p.y = abs(p.y) - .5;
	p.xy *= r2d(1.4);

	// spinal
	float t = 2.;
	p.z = mod(p.z - t*.5, t) - t*.5;
	float d = max(cyl(p.yzx, 1.2, .1), -cyl(p.yzx - vec3(.15, 0, 0), 1.1, .9));
	d = smin(d, box(p - vec3(0, -1.05, 0), vec3(.1, .1, 1.)), .4);
	surface = vec4(1, 1, 1, d);

	q = p;

	// medium tubes
	p.y -= 2.;
	amod(p.xy, 8.);
	mo(p.xy, vec2(.4, .1));
	d = sph(p.xy, .1);
	p.z = rep(p.z, 6.);
	p.y *= .7;
	d = min(d, sph(p, .15));
	d = min(d, bg_tun);
	surface = opu(surface, vec4(.2, .3, .4, d));

	// big tubes
	p = q;
	amod(p.xy, 3.);
	mo(p.xy, vec2(1.9));
	d = sph(p.xy, .8);
	surface = opu(surface, vec4(.7, .1, .1, d));

	// small tubes
	p = q;
	p.x -= .1;
	p.y += .5;
	amod(p.xy, 8.);
	mo(p.xy, vec2(.1, .1));
	d = sph(p.xy, .02);
	surface = opu(surface, vec4(.3, .2, .2, d));

	return surface;

}

vec3 camera(vec3 ro, vec2 uv, vec3 ta) {
	vec3 fwd = normalize(ta - ro);
	vec3 left = cross(vec3(0, 1, 0), fwd);
	vec3 up = cross(fwd, left);
	return normalize(fwd + uv.x*left + up*uv.y);
}

vec3 normal(in vec3 pos)
{
	vec2 e = vec2(1., -1.)*.5773*.0005;
	return normalize(e.xyy*de(pos + e.xyy).w +
		e.yyx*de(pos + e.yyx).w +
		e.yxy*de(pos + e.yxy).w +
		e.xxx*de(pos + e.xxx).w);
}

// from iq's boxmapping: https://www.shadertoy.com/view/MtsGWH
vec4 boxmap(sampler2D sam, in vec3 p, in vec3 n, in float k)
{
	vec3 m = pow(abs(n), vec3(k));
	vec4 x = texture2D(sam, p.yz);
	vec4 y = texture2D(sam, p.zx);
	vec4 z = texture2D(sam, p.xy);
	return (x*m.x + y*m.y + z*m.z) / (m.x + m.y + m.z);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 q = fragCoord.xy / iResolution.xy;
	vec2 uv = (q - .5) * iResolution.xx / iResolution.yx;


	float dt = iTime * 6.;
	vec3 ro = vec3(cos(iTime)*.5, sin(iTime)*.5, -4. + dt);
	vec3 ta = vec3(0, 0, dt);
	vec3 rd;

	ro.xy += path(ro.z);
	ta.xy += path(ta.z);

	rd = camera(ro, uv, ta);

	vec3 p;
	vec4 res;
	float ri, t = 0.;
	for (float i = 0.; i < 1.; i += .01) {
		ri = i;
		p = ro + rd*t;
		res = de(p);
		if (res.w<.001 || t>30.) break;
		t += res.w;
	}

	vec3 bg = vec3(.15, .0, .0);
	vec3 col = bg;
	if (t <= 100.) {
		vec3 n = normal(p);
		col = boxmap(iChannel0, p + .3, n, 32.).rgb * res.rgb;
		col = col * (uv.y + .5)*1.7;
		col *= dot(n, normalize(vec3(1., 1., -1.)));
		col = smoothstep(0., 1., col);
	}

	float dist = length(ro - p);
	col = mix(col, bg, 1. - exp(-.007 * dist*dist));
    
    col *= 2.;
    col /= col + 1.; // then remap, with tone mapping
    
    // you may try this to increase brighness (proposed by movAX13h)
    col = clamp(col, 0., 1.);
	col = pow(col, vec3(2.2, 2.4, 2.5)) * 3.9;
	col = pow(col, vec3(.4545));
    
	// iq's vignetting
	col *= 0.5 + 0.5*pow(16.0*q.x*q.y*(1.0 - q.x)*(1.0 - q.y), 0.25);

	fragColor = vec4(col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

